//	CFolderPro.h

#ifndef _H_CFolderPro
#define _H_CFolderPro

#include "CFolder.h"
#include "ProStructs.h"

typedef		OSErr	Pro_ForEachEntryCB(
	CFolderPro			*thiz, 
	Pro_DirEntry		*entry, 
	Pro_BlockNum		block, 
	Pro_EntryIndex		entryIndex, 
	Boolean				*done, 
	void				*data);

typedef struct {
	short		levelS;
} Pro_DumpFolderRec;

class CFolderPro : public CFolder {

	public:	
	
	OSErr	IFolderPro(
		CDiskPro			*cDiskPro, 
		CFolderPro			*cParentFolderPro, 
		Pro_BlockNum		block, 
		Pro_EntryIndex		diskLocDirEntryIndex,	//	relative to cur dir sector
		Pro_EntryIndex		directoryIndex			//	relative to entire directory
	);

	virtual	void	Dispose(void);
	
			Pro_BlockNum	GetDirKeyBlock(void);
			Pro_BlockNum	GetLastDirBlock(void);
			Boolean			GetEmptyEntry(Pro_EntryLocSpec *entryLoc);
			OSErr			ZeroDirectory(Boolean key, Pro_BlockNum block);

			OSErr			ForEachEntry(Pro_ForEachEntryCB Pro_ForEachUserCB, void *data);
			Boolean			GetUniqueName(char *fileName);

			OSErr			ExtendDirectory(void);

	static	OSErr	MakeNewEntryCB(
				CFolderPro			*thiz, 
				Pro_DirEntry		*entry, 
				Pro_BlockNum		block, 
				Pro_EntryIndex		entryIndex, 
				Boolean				*done, 
				void				*data);
			
			//	returns TRUE if success
			OSErr			MakeNewEntry(
				Pro_DirEntry		*entry, 
				Pro_BlockNum		block, 
				Pro_EntryIndex		diskLocDirEntryIndex, 
				Gen_MakeEntryData	*dataP, 
				CEntry				**newEntry0 = NULL, 
				Boolean				verifyB = TRUE);
				
	virtual	void			ConformStrLen(char* nameStr);

	virtual	void			SetName(char *buf);
	virtual	DateTimeRec		*GetCreatedTime(DateTimeRec *dt);
	virtual	DateTimeRec		*GetModifiedTime(DateTimeRec *dt);
	virtual	void			SetCreatedTime(DateTimeRec *dt);
	virtual	void			SetModifiedTime(DateTimeRec *dt);

	virtual	char			*GetName(char *buf);
	virtual	OSErr			IsKeyBlock(Pro_BlockNum block, Boolean *isKeyB);
	
	virtual	Pro_DirHeader	*GetMyHeader(void);
	OSErr					FlushHeader(void);

	virtual	Pro_DirEntry	*GetMyEntry(void);
	OSErr					FlushEntry(void);	

	virtual	Pro_DirEntry	*GetEntry(Pro_BlockNum block, Pro_EntryIndex entryIndex);
	
	virtual	Pro_DirBlock	*GetMyDirBlock(void);
	virtual	char			*GetDescription(char *buf);
	virtual	OSErr			NewFile(Boolean isFolder, CEntry **entryH);
	virtual	void			GetAccessBits(Gen_AccessBits *bits);
	virtual	void			SetAccessBits(Gen_AccessBits *bits);
	CEntry					*GetFileFromEntry(Pro_DirEntry *entryP);

	virtual	OSErr			PutFileNewEntry(Handle fileH);

	OSErr			GetEntryLoc(Pro_EntryIndex dirIndex, Pro_EntryLocSpec *entryLoc);

	void			SetTwirled(Boolean twirledB);	
	Boolean			GetTwirled(void);

	OSErr			IncrementDirCount(short numIncS);
	OSErr			Pro_DeleteEntry(Pro_EntryIndex dirIndex);
	OSErr			Pro_DeleteEntryR(
		Pro_StorageType		storageType,
		Pro_BlockNum		index_blockS);
		
	virtual	Boolean		IsDeleted(void);
	virtual	OSErr		Delete(Boolean warnB = FALSE, CDialogCopy *copyP0 = NULL);
	virtual	OSErr		UnDelete(Boolean recursiveB = FALSE, CDialogCopy *copyP0 = NULL);

	OSErr		GetGetFolderBlocks(
		Pro_BlockNum *blockA0, 
		Pro_BlockNum *numBlocksSP0);

	virtual	OSErr		GetEntryAlloc(
		Boolean			getAsBlocksB, 
		Gen_EntryAlloc	**sectorListH);

	virtual	OSErr		NewFolder(CEntry **newFolderH);
	virtual	OSErr		MoveFile(CEntry *srcEntryP, CEntry *dstEntryP);
	virtual	ulong		GetPhysicalSize(void);
	virtual	ulong		GetLogicalSize(void);
	virtual	OSErr		AddEntries(Boolean normalB, Boolean deletedB);

	OSErr				DumpFolder(Pro_DumpFolderRec *dumpP);
	OSErr				DumpFolder_Self(
		Pro_DirEntry		*entry, 
		Pro_BlockNum		block, 
		Pro_EntryIndex		diskLocDirEntryIndex, 
		Pro_DumpFolderRec	*dumpP);

	private:
	
	Pro_DirEntry		i_myEntry;
	
	typedef CFolder _inherited;
};


#endif
